#pragma GCC target("sse,sse2,sse3,ssse3,sse4,popcnt,abm,mmx,avx,avx2")

#include <bits/stdc++.h>

template<class t> using vc = std::vector<t>;

#define nd node*
#define pnd pair<nd, nd>

using namespace std;
typedef long long ll;
typedef vector<ll> vll;
typedef pair<ll, ll> pll;
typedef vc<pll> vpll;
typedef vc<vll> vvll;
typedef vc<vpll> vvpll;

template<const ll MOD>
struct mod_mul : std::multiplies<const ll> {
    ll operator()(const ll a, const ll b) {
        return (a * b) % MOD;
    }
};


template<typename T>
inline void sort(T &a) {
    sort(a.begin(), a.end());
}

template<typename T>
inline void unique(T &a) {
    a.resize(unique(a.begin(), a.end()) - a.begin());
}

template<typename T>
inline void reverse(T &a) {
    reverse(a.begin(), a.end());
}

const ll INF = 9023372036854775808ll;
const ll MOD = 998244353ll;

ll pw(ll a, ll b) {
    ll ans = 1;
    while (b) {
        if (b & 1) (ans *= a) %= MOD;
        b /= 2, a = a * a % MOD;
    }
    return ans;
}

ll dp[5005][5005];

int main() {
    cin.tie(nullptr)->ios_base::sync_with_stdio(false);
    int t;
    cin >> t;
    while (t--) {
        int n, m;
        cin >> n >> m;
        for (int x = 0; x <= n; ++x) {
            for (int y = 0; y <= n; ++y) {
                dp[x][y] = 0;
            }
        }
        dp[0][0] = 1;
        for (int i = 1; i <= n; ++i) {
            for (int j = 0; j <= 0; ++j) {
                for (int max = 0; max <= j; ++max) {
                    dp[i][std::max(max, i - j)] += dp[j][max] * m;
                    dp[i][std::max(max, i - j)] %= MOD;
                }
            }
            for (int j = 1; j < i; ++j) {
#pragma GCC ivdep
                for (int max = 0; max <= i - j; ++max) {
                    dp[i][i - j] += dp[j][max] * (m - 1);
                    dp[i][i - j] %= MOD;
                }
            }
            for (int j = 1; j < i; ++j) {
#pragma GCC ivdep
                for (int max = i - j + 1; max <= j; ++max) {
                    dp[i][max] += dp[j][max] * (m - 1);
                    dp[i][max] %= MOD;
                }
            }
        }
        ll ans = 0;
        for (int x = 0; x <= n; ++x) {
            ans += dp[n][x] * x;
            ans %= MOD;
        }
        cout << ans * pw(pw(m, n), MOD - 2) % MOD << '\n';
    }
}